/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.config;

import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.config.annoconfg.AnnoCFG;
import net.montoyo.wd.config.annoconfg.annotation.format.CFGSegment;
import net.montoyo.wd.config.annoconfg.annotation.format.Comment;
import net.montoyo.wd.config.annoconfg.annotation.format.Config;
import net.montoyo.wd.config.annoconfg.annotation.format.Name;
import net.montoyo.wd.config.annoconfg.annotation.format.Translation;
import net.montoyo.wd.config.annoconfg.annotation.value.Default;
import net.montoyo.wd.config.annoconfg.annotation.value.DoubleRange;
import net.montoyo.wd.config.annoconfg.annotation.value.IntRange;

@Config(type=ModConfig.Type.CLIENT)
public class ClientConfig {
    private static final AnnoCFG CFG = new AnnoCFG(FMLJavaModLoadingContext.get().getModEventBus(), ClientConfig.class);
    @Name(value="load_distance")
    @Comment(value={"How far (in blocks) you can be before a screen starts rendering"})
    @Translation(value="config.webdisplays.load_distance")
    @DoubleRange(minV=0.0, maxV=1.7976931348623157E308)
    @Default(valueD=30.0)
    public static double loadDistance = 30.0;
    @Name(value="unload_distance")
    @Comment(value={"How far you can be before a screen stops rendering"})
    @Translation(value="config.webdisplays.unload_distance")
    @DoubleRange(minV=0.0, maxV=1.7976931348623157E308)
    @Default(valueD=32.0)
    public static double unloadDistance = 32.0;
    @Name(value="pad_resolution")
    @Comment(value={"The resolution that minePads should use", "Smaller values produce lower qualities, higher values produce higher qualities", "Due to how web browsers work however, the larger this value is, the smaller text is", "Also, higher values will invariably lag more", "A good goto value for this would be the height of your monitor, in pixels", "A standard monitor is (at least currently) 1080"})
    @Translation(value="config.webdisplays.pad_res")
    @IntRange(minV=0, maxV=0x7FFFFFFF)
    @Default(valueI=720)
    public static int padResolution = 720;
    @Name(value="side_pad")
    @Comment(value={"When this is true, the minePad is placed off to the side of the screen when held, so it's visible but doesn't take up too much of the screen", "When this is false, the minePad is placed closer to the center of the screen, allow it to be seen better, but taking up more of your view"})
    @Translation(value="config.webdisplays.side_pad")
    @Default(valueBoolean=true)
    public static boolean sidePad = true;
    @Name(value="switch_buttons")
    @Comment(value={"If the left and right buttons should be swapped when using a laser"})
    @Translation(value="config.webdisplays.switch_buttons")
    @DoubleRange(minV=0.0, maxV=1.7976931348623157E308)
    @Default(valueD=30.0)
    public static boolean switchButtons = true;

    public static void init() {
    }

    public static void postLoad() {
        if (unloadDistance < loadDistance + 2.0) {
            unloadDistance = loadDistance + 2.0;
        }
        if (AutoVolumeControl.dist0 < AutoVolumeControl.dist100 + 0.1) {
            AutoVolumeControl.dist0 = AutoVolumeControl.dist100 + 0.1;
        }
        WebDisplays.INSTANCE.padResY = padResolution;
        WebDisplays.INSTANCE.padResX = WebDisplays.INSTANCE.padResY * 1.9666666666666666;
        WebDisplays.INSTANCE.unloadDistance2 = unloadDistance * unloadDistance;
        WebDisplays.INSTANCE.loadDistance2 = loadDistance * loadDistance;
        WebDisplays.INSTANCE.ytVolume = (float)AutoVolumeControl.ytVolume;
        WebDisplays.INSTANCE.avDist100 = (float)AutoVolumeControl.dist100;
        WebDisplays.INSTANCE.avDist0 = (float)AutoVolumeControl.dist0;
    }

    @Comment(value={"AutoVolume makes audio fade off based on distance", "Currently, this seems to not work"})
    @CFGSegment(value="auto_volume")
    public static class AutoVolumeControl {
        @Name(value="enabled")
        @Comment(value={"Whether or not auto volume should be enabled"})
        @Translation(value="config.webdisplays.auto_vol")
        @Default(valueBoolean=true)
        public static boolean enableAutoVolume = true;
        @Name(value="youtube_volume")
        @Comment(value={"How loud youtube should be by default"})
        @Translation(value="config.webdisplays.yt_vol")
        @DoubleRange(minV=0.0, maxV=100.0)
        @Default(valueD=100.0)
        public static double ytVolume = 100.0;
        @Name(value="dist0")
        @Comment(value={"Distance after which you can't hear anything (in blocks)"})
        @Translation(value="config.webdisplays.d0")
        @DoubleRange(minV=0.0, maxV=1.7976931348623157E308)
        @Default(valueD=30.0)
        public static double dist0 = 30.0;
        @Name(value="dist100")
        @Comment(value={"Distance after which the sound starts dropping (in blocks)"})
        @Translation(value="config.webdisplays.d100")
        @DoubleRange(minV=0.0, maxV=1.7976931348623157E308)
        @Default(valueD=10.0)
        public static double dist100 = 10.0;
    }
}

